/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.api.crop;

import com.agricraft.agricraft.api.config.CoreConfig;
import com.agricraft.agricraft.api.crop.AgriCrop;
import net.minecraft.class_5819;

public class AgriGrowthStage {
    private final int stage;
    private final int total;

    public AgriGrowthStage(int stage, int total) {
        this.stage = stage;
        this.total = total;
    }

    public int index() {
        return this.stage;
    }

    public int total() {
        return this.total;
    }

    public boolean isMature() {
        return this.isFinal();
    }

    public boolean isFinal() {
        return this.stage >= this.total - 1;
    }

    public boolean canDropSeed() {
        return this.isFinal() || !CoreConfig.onlyMatureSeedDrops;
    }

    public AgriGrowthStage getNext(AgriCrop crop, class_5819 random) {
        return this.isFinal() ? this : new AgriGrowthStage(this.stage + 1, this.total);
    }

    public AgriGrowthStage getPrevious(AgriCrop crop, class_5819 random) {
        return this.stage <= 0 ? this : new AgriGrowthStage(this.stage - 1, this.total);
    }

    public double growthPercentage() {
        return ((double)this.stage + 1.0) / (double)this.total;
    }

    public String toString() {
        return "AgriGrowthStage{stage=" + this.stage + ", total=" + this.total + "}";
    }
}

